/*------------------------------------------------------------------------------*
 * File Name: RangeEx.h															*
 * Creation: CPY 04/18/05														*
 * Purpose: Origin C support for Range derived classes							*
 * Copyright (c) OriginLab Corp.2004											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *  SY 12/15/2004 QA70-7258 v8.0175 IMPORT_INFO_RESET_AND_DATARANGE_SAVEAS_UID	*
 *	YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS				*
 *	ML 2/28/2005 QA70-7450 MATRICES_IN_DATARANGE								*
 *	ML 3/21/2005 OPERATIONTREE_UPDATING_BACK_AND_FORTH							*
 *	RVD 4/15/2005 QA70-7597 v8.0223 MARKER_GROBJ								*
 *	YuI 06/29/05 XVARIABLE_ACTIVE_CLEANUP										*
 *	ML 8/29/2005 QA70-7547 UNDOABLE_XF_EXECUTION								*
 *	CPY 10/5/05 QA70-8154 XF_AUTO_CREATE_DATA									*
 *	YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS		*
 *	Kevin 11/14/05 SUPPORT_ADD_STRING_ARRAY_IN_ROW								*
 *	YuI 11/28/05 XYRANGE_INITIALIZATION_WITHOUT_XVARIABLE						*
 *	YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES				*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 *  Sandy 2/7/2006 RENAME_WITHOUT_RANGE											*
 *  Jim 2/22/06 ADD_RESIDUAL_LAG_PLOT_TO_RESIDUALS_PLOTS_BRANCH					*
 *	ML 2/28/2006 XYRANGE_SETDATA_YERROR											*
 *	ML 3/13/2006 SETTING_DESIGS_ON_SET_DATA										*
 *	ML 3/14/2006 POLYRANGE_COMPLEX_DATA_RETRIEVAL								*
 *	ML 3/17/2006 SETTING_COMPLEX_DATA_INTO_XYRANGE								*
 *	RVD 11/22/2006 QA70-9148 v8.0515 IMPLEMENT_RECTINFO							*
 *	ML 12/18/2006 CALLING_OPERATION_FROM_OC_LT									*
 *	ML 3/26/2007 QA70-9532 DATARANGE_TO_XY_AND_Z_RANGE_ASSIGNMENTS				*
 *	ML 10/3/2007 QA70-10474 NO_CHANGING_i2_ON_XYRANGE_SET_DATA_BY_DEFAULT		*
 *	Sim 01-17-2007 QA80-10952 MULTI_SHEET_RANGE									*
 *	Folger 02/14/08 QA80-10946 SUPPORT_GET_SUB_RANGE_PER_SHEET					*
 *	ML 11/10/2008 QA70-12356 RANGE_GET_DATA_PROVIDE_MAP_OF_MISSING_VALUES		*
 *	Folger 11/26/08 QA80-12367-S1 v8.0980 LINEINFO_SNAP_TO_DATA_SUPPORT_DATA_POINT_INDEX_ACCESS
 *	ML 12/12/2008 QA70-12715 SNAPTO_FOR_ALL_GRAPHOBJINFOS						*
 *	Folger 12/30/08 v8.0992 GET_FULL_ROW_RANGE_FROM_XYRANGE_WANTED_BY_SANDY		*
 *	RVD 1/16/2009 qa70-12981 MARKER_INFO_SNAP_TO_DATA_CLEANUP					*
 *	Kyle 03/13/2009 QA80-13260-S1 ADD_OPTION_TO_COPY_FORMAT_FROM_SOURCE_LAYER	*
 *	YuI 03/13/09 QA70-13281 TAGGING_AVECURVES_RESULTS_TO_EXCLUDE_THEM_FROM_FUTURE_AVERAGING*
 *	Folger 03/16/09 QA80-13260-P1 MULTIPLE_SOURCE_XYRANGES_PLOTTING_IN_XF_PREVIEW_DIALOG
 *	YuI 07/27/09 QA70-14023 EVEN_SAMPLING_LOOSE_DATASET_XYRANGE_ACCESS			*
 *	Folger 07/29/09 QA80-14031 SUPPORT_LOOSE_DATASET_SET_EVEN_SAMPLING			*
 *	YuI 10/12/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT							*
 *	Folger 01/06/09 QA81-14903 FILTER_DATAPLOTS_TAGS_WITH_FITCURVES				*
 *------------------------------------------------------------------------------*/
#ifndef	_RANGE_EX_H
#define	_RANGE_EX_H

/// ML 1/13/2006 XVARIABLEBASE_TO_VC
//#define	XVAR_OIRIGINOBJECT_COLUMN_COLLECTION_DESCRIPTOR			"COL("
//#define	XVAR_OIRIGINOBJECT_DATAPLOT_COLLECTION_DESCRIPTOR		"PLOT("
//#define	XVAR_OIRIGINOBJECT_GRAPHOBJECT_COLLECTION_DESCRIPTOR	"OBJ("
//#define	XVAR_OIRIGINOBJECT_MATRIXOBJECT_COLLECTION_DESCRIPTOR	"MAT("
//#define	RANGE_SHORT_NOTATION_SEPARATOR	','
/// end XVARIABLEBASE_TO_VC

/// SY 12/15/2004 QA70-7258 v8.0175 IMPORT_INFO_RESET_AND_DATARANGE_SAVEAS_UID
// Comments last updated by Iris on 03/13/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:DataRangeEx_(class)
*/
class DataRangeEx : public DataRange
{
public:
	// Comments last updated by Hong on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRangeEx-DataRangeEx
	*/
	DataRangeEx();
	
	// Comments last updated by Hong on 03/12/07
	/**$
		Destructor for the DataRangeEx class
	*/
	DataRangeEx(TreeNode& tr, bool bUpdateTree = false);
	
	// Comments last updated by Hong on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRangeEx-~DataRangeEx
	*/
	~DataRangeEx();
	
public:
	
	// Create datarange
	// Comments last updated by Hong on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRangeEx-Create
	*/
	bool Create(TreeNode& tr, bool bOneData = true);
	// Comments last updated by Hong on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRangeEx-Save
	*/
	bool Save();
	
	//Comment last updated by Joseph 09/11/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRangeEx-Add
	*/
	int	Add(LPCSTR lpcszRange, LPCSTR lpcszName = NULL);
	// Comments last updated by Hong on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRangeEx-Add
	*/
	int	Add(Worksheet& wks, int nR1, int nC1, int nR2, int nC2, LPCSTR lpcszName = NULL);

	// Get c1 c2 of data range
	// Comments last updated by Hong on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRangeEx-GetRange
	*/
	bool GetRange(int& c1, int& c2, int nIndex = 0);
	
	// Get worksheet of data range
	// Comments last updated by Hong on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRangeEx-GetRange
	*/
	//bool GetRange(Worksheet& wks, int nIndex = 0); CPY 8/9/06 WKS_DATASHEET_CLEAN_UP, changed from Worksheet To Datasheet
	bool GetRange(Datasheet& ds, int nIndex = 0);
	// Comments last updated by Hong on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataRangeEx-PrepareTree
	*/
	void PrepareTree(TreeNode& tr);
	
private:
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	string getUID(string& strGUID);
	
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	string getExcelRange(LPCSTR lpcszName = NULL);
	
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/	
	bool m_bCreated;
	
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/	
	bool m_bSaved;
};
/// end IMPORT_INFO_RESET_AND_DATARANGE_SAVEAS_UID

/// YuI 03/19/07 QA70-9503 MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
//	#define		SelfCreatingDataRange	SelfCreatingRange
/// end MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
// Comments last updated by Iris on 03/13/2007
/** >Internal Origin Objects
*/

/// YuI 03/19/07 QA70-9503 MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
//	class	SelfCreatingRange	:	public	DataRange
//	{
//	public:
		// Comments last updated by Iris on 03/13/2007
		/** 
		Remarks: 
		
		Keywords: 
		
		Example1: 
		
		Parameters:
			
		Return: 
		
		SeeAlso: 
		*/
//		bool			InitFromTree();
	
		// Comments last updated by Iris on 03/13/2007
		/** 
		Remarks: 
		
		Keywords: 
		
		Example1: 
		
		Parameters:
			
		Return: 
		
		SeeAlso: 
		*/
//		void			SetUndoable(BOOL bSet = TRUE);
		
		// Comments last updated by Iris on 03/13/2007
		/** 
		Remarks: 
		
		Keywords: 
		
		Example1: 
		
		Parameters: 
		
		Return: 
		
		SeeAlso: 
		*/
//		BOOL			IsUndoable();	
		
		// Comments last updated by Iris on 03/13/2007
		/** 
		Remarks: 
		
		Keywords: 
		
		Example1: 
		
		Parameters: 
		
		Return: 
		
		SeeAlso: 
		*/
//		TreeNode		GetSCTree();
		
		// Comments last updated by Iris on 03/13/2007
		/** 
		Remarks: 
		
		Keywords: 
		
		Example1: 
		
		Parameters:
			
		Return: 
		
		SeeAlso: 
		*/
//		void			SetSCTree(TreeNode& tr);
		
		// Comments last updated by Iris on 03/13/2007
		/** 
		Remarks: 
		
		Keywords:
			
		Example1: 
		
		Parameters: 
		
		Return: 
		
		SeeAlso: 
		*/
//		BOOL			GetRuntimeDescription(string& strDescription, int nIndex = 0);
		
		// Comments last updated by Iris on 03/13/2007
		/** 
		Remarks: 
		
		Keywords: 
		
		Example1: 
		
		Parameters: 
		
		Return: 
		
		SeeAlso: 
		*/
//		BOOL			GetBookSheet(string& strBook, string& strSheet, int nIndex = 0);
		
		// Comments last updated by Iris on 03/13/2007
		/** 
		Remarks: 
		
		Keywords: 
		
		Example1: 
		
		Parameters: 
		
		Return: 
		
		SeeAlso: 
		*/
//		BOOL			NewGetBookDescriptor(string& strDescriptor, int nIndex = 0, LPCSTR lpcszBranch = "X");
	
		// Comments last updated by Iris on 03/13/2007
		/** 
		Remarks:
			
		Keywords: 
		
		Example1: 
		
		Parameters: 
		
		Return: 
		
		SeeAlso: 
		*/
//		BOOL			NewGetSheetDescriptor(string& strDescriptor, int nIndex = 0, LPCSTR lpcszBranch = "X");
	
		// Comments last updated by Iris on 03/13/2007
		/** 
		Remarks:  
		
		Keywords: 
		
		Example1: 
		
		Parameters: 
		
		Return: 
		
		SeeAlso: 
		*/
//		BOOL			NewGetObjectDescriptor(string& strDescriptor, int nIndex = 0, LPCSTR lpcszBranch = "X");
//	};
/// end MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE


/// YuI 06/29/05 XVARIABLE_ACTIVE_CLEANUP
/**$
*/
BOOL	copy_plot_uid_from_tree_to_tree(TreeNode& trDest, TreeNode& trSource);

//Sandy 2006-2-7 RENAME_WITHOUT_RANGE
/**$
*/
//BOOL	get_plot_uid_from_range_tree(TreeNode& tr, int& nPlotUID);
//void	set_plot_uid_to_range_tree(TreeNode& tr, int nPlotUID);
BOOL	get_plot_uid_from_tree(TreeNode& tr, int& nPlotUID);
/**$
*/
void	set_plot_uid_to_tree(TreeNode& tr, int nPlotUID);
/**$
*/
BOOL	get_data_plot_from_range_tree(TreeNode& tr, DataPlot& dp);
/// end XVARIABLE_ACTIVE_CLEANUP

// Comments last updated by Iris on 03/13/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:XYRange_(class)
*/
/// YuI 03/19/07 QA70-9503 MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
//	class XYRange : public SelfCreatingRange
class XYRange : public DataRange
/// end MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
{
public:

	/// ML 3/26/2007 QA70-9532 DATARANGE_TO_XY_AND_Z_RANGE_ASSIGNMENTS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-XYRange
	*/
	XYRange();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-XYRange
	*/
	XYRange(const DataRange &source);
	/// end DATARANGE_TO_XY_AND_Z_RANGE_ASSIGNMENTS


	// Comments last updated by Echo on 03/15/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-GetData
	*/
	//CPY 2/12/06 dwRulesEx allow optional control, DRR_GET_DEPENDENT is internally set
	//---- CPY 7/5/06 XY_GET_DATA_DEFAULT_TO_SKIP_MISSING
	//BOOL    	GetData(vector &vy, vector &vx, vector *pvError = NULL, int nIndex = 0, DWORD dwRulesEx = DRR_GET_MISSING | DRR_BAD_WEIGHT_TREATMENT);
	/// ML 11/10/2008 QA70-12356 RANGE_GET_DATA_PROVIDE_MAP_OF_MISSING_VALUES
	//BOOL    	GetData(vector &vy, vector &vx, vector *pvError = NULL, int nIndex = 0, DWORD dwRulesEx = DRR_BAD_WEIGHT_TREATMENT);
	BOOL    	GetData(vector &vy, vector &vx, vector *pvError = NULL, int nIndex = 0, DWORD dwRulesEx = DRR_BAD_WEIGHT_TREATMENT, vector<int> *pnMissingValsIndices = NULL);
	/// end RANGE_GET_DATA_PROVIDE_MAP_OF_MISSING_VALUES
	
	// Comments last updated by Echo on 03/15/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-SetData
	*/
	//----
	/// ML 3/13/2006 SETTING_DESIGS_ON_SET_DATA
	///// ML 2/28/2006 XYRANGE_SETDATA_YERROR
	////BOOL		SetData(vector *pvY, vector *pvX, int nIndex = 0);
	//BOOL		SetData(vector *pvY, vector *pvX, int nIndex = 0, vector *pvYErr = NULL);
	///// end XYRANGE_SETDATA_YERROR
	/// ML 10/3/2007 QA70-10474 NO_CHANGING_i2_ON_XYRANGE_SET_DATA_BY_DEFAULT
	////----- CPY 8/16/2007 QA70-10252 XF_FRAME_WORK_WILL_SET_COL_DESIGNATION
	////BOOL		SetData(vector *pvY, vector *pvX, int nIndex = 0, vector *pvYErr = NULL, DWORD dwDRSOpts = DRS_SET_COL_DESIGNATIONS);
	//BOOL		SetData(vector *pvY, vector *pvX, int nIndex = 0, vector *pvYErr = NULL, DWORD dwDRSOpts = 0);
	////----
	///// end SETTING_DESIGS_ON_SET_DATA
	BOOL		SetData(vector *pvY, vector *pvX, int nIndex = 0, vector *pvYErr = NULL, DWORD dwDRSOpts = DRS_KEEP_LARGER_DEST_SIZE);
	/// end NO_CHANGING_i2_ON_XYRANGE_SET_DATA_BY_DEFAULT
	
	// Comments last updated by Echo on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-GetPlot
	*/
	/// YuI 12/04/08 QA70-12159 DATA_MARKERS_IN_WIZARD_PROBLEM
	//	BOOL		GetPlot(DataPlot& dp, int nIndex = 0);
	BOOL		GetPlot(DataPlot& dp, int nIndex = 0, int* pr1 = NULL, int* pr2=NULL);
	/// end DATA_MARKERS_IN_WIZARD_PROBLEM
	
	// Comments last updated by Echo on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-MakePlot
	*/
	DataPlot	MakePlot(GraphLayer& gl, TreeNode& trPlottingInfo = NULL, int nIndex = 0);
	
	// Comments last updated by Echo on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-MakePlot
	*/
	DataPlot	MakePlot(XYRange& rgSrc, TreeNode& trPlottingInfo = NULL, int nIndex = 0);
	
	// Comments last updated by Echo on 03/15/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-GetXColumn
	*/
	BOOL		GetXColumn(Column& col, int nIndex = 0, int* pr1 = NULL, int* pr2=NULL);
	
	// Comments last updated by Echo on 03/15/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-GetYColumn
	*/
	BOOL		GetYColumn(Column& col, int nIndex = 0, int* pr1 = NULL, int* pr2=NULL);
	
	// Comments last updated by Echo on 03/15/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-GetErrColumn
	*/
	BOOL		GetErrColumn(Column& col, int nIndex = 0, int* pr1 = NULL, int* pr2=NULL);

	/// YuI 07/27/09 QA70-14023 EVEN_SAMPLING_LOOSE_DATASET_XYRANGE_ACCESS
	/**+
	*/
	BOOL IsEvenSampling(int nDataIndex, double* px0=NULL, double* pxInc=NULL, string* pStrXUnits = NULL, string* pStrXLongName = NULL);
	/// end EVEN_SAMPLING_LOOSE_DATASET_XYRANGE_ACCESS

	///------ Folger 07/29/09 QA80-14031 SUPPORT_LOOSE_DATASET_SET_EVEN_SAMPLING
	/**+
	*/
	BOOL SetEvenSampling(double dX0, double dXInc, int nDataIndex = 0, LPCSTR lpcszXUnits = NULL, LPCSTR lpcszXLongName = NULL, LPCSTR lpcszDispFormat = NULL, BOOL bUndo = FALSE);
	///------ End SUPPORT_LOOSE_DATASET_SET_EVEN_SAMPLING
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-GetDatasetNames
	*/
	BOOL GetDatasetNames(string& strY, string& strX=NULL, string& strYErr=NULL, int nIndex = 0);

	// Comments last updated by Echo on 03/15/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-GetDescription
	*/
	BOOL GetDescription(string& str, int nIndex);//---- CPY 8/26/06 FIT_LR_MULTIPLE_DATA_NEED_BETTER_LABEL

	/// ML 12/18/2006 CALLING_OPERATION_FROM_OC_LT
	/**$
		It makes input data tree node appropritae for fitter and LR.
	Parameters:
		tr=if lpcszNameForRoot is supplied, then tr is the parent whose child will be the input data
			node. Otherwise tr is the input data node.
		lpcszNameForRoot=[optional]the tag name for the input data node which is to be the child
			of tr.
	Returns:
		TRUE is success.
	*/
	BOOL		MakeFitterInputDataNode(TreeNode &tr, LPCTSTR lpcszNameForRoot = NULL);
	/// end CALLING_OPERATION_FROM_OC_LT

	///------ Folger 12/30/08 v8.0992 GET_FULL_ROW_RANGE_FROM_XYRANGE_WANTED_BY_SANDY
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRange-MakeFullRowRange
	*/
	BOOL		MakeFullRowRange(XYRange& xy);
	///------ End GET_FULL_ROW_RANGE_FROM_XYRANGE_WANTED_BY_SANDY
};


////////////////////////////////////////////////////
// class XYRangeComplex
////////////////////////////////////////////////////
// Comments last updated by Iris on 03/13/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:XYRangeComplex_(class)
*/
class	XYRangeComplex	:	public	XYRange
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRangeComplex-SetData
	*/
	BOOL		SetData(vector<complex> *pvY, vector *pvX, int nIndex = 0, DWORD dwDRSOpts = DRS_SET_COL_DESIGNATIONS);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRangeComplex-SetData
	*/
	BOOL		SetData(vector *pvYReal, vector *pvYImag, vector *pvX, int nIndex = 0, DWORD dwDRSOpts = DRS_SET_COL_DESIGNATIONS);
	
	//Comment last updated by Joseph 09/11/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRangeComplex-GetData
	*/
	BOOL		GetData(vector<complex> &vy, vector &vx, int nIndex = 0);
	
	//Comment last updated by Joseph 09/11/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYRangeComplex-GetData
	*/
	BOOL		GetData(vector &vyReal, vector &vyImag, vector &vx, int nIndex = 0);
};

// Comments last updated by Iris on 03/13/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:XYZRange_(class)
*/
/// YuI 03/19/07 QA70-9503 MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
//	class XYZRange : public SelfCreatingRange
class XYZRange : public DataRange
/// end MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
{
public:
	/// ML 3/26/2007 QA70-9532 DATARANGE_TO_XY_AND_Z_RANGE_ASSIGNMENTS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYZRange-XYZRange
	*/
	XYZRange();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYZRange-XYZRange
	*/
	XYZRange(const DataRange &source);
	/// end DATARANGE_TO_XY_AND_Z_RANGE_ASSIGNMENTS
	
	// Comments last updated by Echo on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYZRange-GetData
	*/
	BOOL    	GetData(vector &vz, vector &vy, vector &vx, vector *pvError = NULL, int nIndex = 0, DWORD dwRulesEx = DRR_GET_MISSING | DRR_BAD_WEIGHT_TREATMENT);
	
	// Comments last updated by Echo on 03/12/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:XYZRange-SetData
	*/
	/// ML 3/13/2006 SETTING_DESIGS_ON_SET_DATA
	//BOOL		SetData(vector *pvZ, vector *pvY, vector *pvX, int nIndex = 0);
	BOOL		SetData(vector *pvZ, vector *pvY, vector *pvX, int nIndex = 0, DWORD dwDRSOpts = DRS_SET_COL_DESIGNATIONS);
	/// end SETTING_DESIGS_ON_SET_DATA
	
	/// YuI 10/12/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT
	#ifdef __X_RANGE_POLYRANGE_SUPPORT__
	/**
	*/
	BOOL			GetXRange(LPDOUBLE pX1, LPDOUBLE pX2, int nDataIndex = 0);

	/**
	*/
	BOOL			SetXRange(double dX1, double dX2, int nDataIndex = 0);
	
	/**
	*/
	BOOL			GetYRange(LPDOUBLE pX1, LPDOUBLE pX2, int nDataIndex = 0);
	
	/**
	*/
	BOOL			SetYRange(double dX1, double dX2, int nDataIndex = 0);		
	#endif // __X_RANGE_POLYRANGE_SUPPORT__
	/// end X_RANGE_POLYRANGE_SUPPORT
};



/// ML 1/13/2006 XVARIABLEBASE_TO_VC
//#define		XVAR_TEMP_INFO_TAG	"RunTime"
/// end XVARIABLEBASE_TO_VC
// Comments last updated by Iris on 03/13/2007
/**# >Data Range
*/
bool	init_data_range_from_data_object(DataRange& dr, DataObject& obj);
/// end MATRIX_OBJECT_XFUNCTION_AUTOUPDATE

/// end XFUNCTION_OC_TO_VC_CONVERSION

//----- CPY 1/4/06 XF_GRAPH_PREVIEW
/**$
	prepare a graph with source data plot and simulated data plot
*/
///Kyle 03/13/2009 QA80-13260-S1 ADD_OPTION_TO_COPY_FORMAT_FROM_SOURCE_LAYER
//bool init_preview_graph(TreeNode& trGetNinputData, PageBase& pgPreview, Worksheet& wksPreview, LPCSTR lpcszGraphTemplate, XYRange* pxyIn = NULL, XYRange* pxyPreviwe= NULL, int nLayer = 0, int nColor = 0, int nResultColor = 1);
enum
{
	PREVIEW_LAYER_FORMAT_SCALE_TYPE = 0x0001,
};

///------ Folger 03/16/09 QA80-13260-P1 MULTIPLE_SOURCE_XYRANGES_PLOTTING_IN_XF_PREVIEW_DIALOG
//bool init_preview_graph(TreeNode& trGetNinputData, PageBase& pgPreview, Worksheet& wksPreview, LPCSTR lpcszGraphTemplate, XYRange* pxyIn = NULL, XYRange* pxyPreviwe= NULL, int nLayer = 0, int nColor = 0, int nResultColor = 1, DWORD dwCopyLayerFormat = 0);
bool init_preview_graph(TreeNode& trGetNinputData, PageBase& pgPreview, Worksheet& wksPreview, LPCSTR lpcszGraphTemplate, XYRange* pxyIn = NULL, XYRange* pxyPreviwe= NULL, int nLayer = 0, int nColor = 0, int nResultColor = 1, DWORD dwCopyLayerFormat = 0, bool bPlotFirstSourceRangeOnly = false);
///------ End MULTIPLE_SOURCE_XYRANGES_PLOTTING_IN_XF_PREVIEW_DIALOG
///End ADD_OPTION_TO_COPY_FORMAT_FROM_SOURCE_LAYER
/**$
*/
bool xy_range_from_GetN_data_node(TreeNode& trGetNinputData, XYRange& xy);
bool xy_range_from_wks_cols(XYRange& xy, Worksheet& wks, int nX, int nY, int nYErr = -1);
//----- end CPY 1/4/06 XF_GRAPH_PREVIEW

// Comments last updated by Joseph on 04/04/2007
/**# >
*/
class InfoBase : public TreeNode
{
public:
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	InfoBase(TreeNode &tr, DWORD dwUIDMain = 0);

public:	
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool		GetParent(OriginObject &obj);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	TreeNode	GetUserData(bool bCheckAdd = false);
};

////////////////////////////////////////////////
// class GraphObjVarBase
////////////////////////////////////////////////
// Comments last updated by Joseph on 04/04/2007
/**# >
*/
class GraphObjInfo : public InfoBase
{
public:
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	GraphObjInfo(TreeNode &tr, DWORD dwUIDMain = 0);
	~GraphObjInfo();
	
public:	
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	int				GetID();
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void 			SetShow(bool bShow);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool 			GetShow();
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	string 			GetText();
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void 			SetText(LPCSTR lpcsz);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void 			SetFontSize(double dSize);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void			SetColor(DWORD dwColor);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	double			GetFontSize();
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	int				FontSizeToPagePixels(double dFontSizeInPts);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	virtual void 	MoveTo(double x, double y);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool 			MoveTo(GraphObject& grSender, int nCorner, double dxGap = 0.05, double dyGap = 0);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool 			GetParentCorner(int nCorner, double& x, double& y, double dxGap = 0, double dyGap = 0);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool			GetParentRect(int &nLeft, int &nTop, int &nRight, int &nBottom);	
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool			GetParentCorner(int nCorner, int &nX, int &nY, int nXGap = 0, int nYGap = 0);
	
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool			PageMoveTo(int nx, int ny);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool			PageMoveTo(int nCorner, int nXGap, int nYGap);

	// Comments last updated by Sim on 03/12/07
	/**
	Remarks: Low level method to get anchor X value. The meaning of this value depends on FollowsParent() mode. 
			If anchor is following the parent to which it is attached to, then this value is index of a parent data point.
			If anchor is not following the parent, then this value is the actual X coordinate of the anchor.
		
	Keywords: anchor, marker, MarkerInfo
		
	Example1: curve translate.oxf
		
	Parameters:
		nIndex = [optional] index of the anchor X value to retrieve

	Return:
		anchor X value
		
	SeeAlso:
		SetXY, GetY, GetWorldXY, FollowsParent, SetFollowsParent
	*/
	double 			GetX(int nIndex =0);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks: Low level method to get anchor Y value. The meaning of this value depends on FollowsParent() mode. 
			If anchor is following the parent to which it is attached, then this value is index of a parent data point.
			If anchor is not following the parent, then this value is the actual Y coordinate of the anchor.
		
	Keywords: anchor, marker, MarkerInfo
		
	Example1: curve translate.oxf
		
	Parameters:		
		nIndex = [optional] index of the anchor X value to retrieve

	Return:
		anchor Y value
		
	SeeAlso:
		SetXY, GetX, GetWorldXY, FollowsParent, SetFollowsParent
	*/
	double 			GetY(int nIndex =0);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks: Low level method to set anchor X and Y values. The meaning of these values depends on FollowsParent() mode. 
			If anchor is following the parent to which it is attached to, then value is an index of a parent data point.
			If anchor is not following the parent, then these values are the actual x and Y coordinates of the anchor.
		
	Keywords: anchor, marker, MarkerInfo
		
	Example1: curve translate.oxf
		
	Parameters:
		vx = vector of X values
		vy = vector of Y values

	Return:
		true if success, false if failure
		
	SeeAlso:
		GetX, GetY, GetWorldXY, FollowsParent, SetFollowsParent
	*/
	bool 			SetXY(const vector& vx, const vector& vy);

	/// RVD 1/16/2009 qa70-12981 MARKER_INFO_SNAP_TO_DATA_CLEANUP
	/**
	Remarks: This method always return X and Y in world space units (axis scale), no matter if object follows the parent or not.
		
	Keywords: anchor, marker, MarkerInfo
		
	Example1:  curve translate.oxf
		
	Parameters:
		nIndex = index of the anchor X value to retrieve
		px = pointer to value which will get the X coordinate, can be NULL
		py = pointer to value which will get the Y coordinate, can be NULL

	Return:
		2 if both 2D coordinates were successfully obtained
		0 if FollowsParent() is TRUE, but no coordinates can be obtained from the parent
		-1 if can not get data from tree
		-2 if nIndex is out of data bounds
		-3 if FollowsParent() is TRUE, but parent is invalid
		
	SeeAlso:
		SetXY, GetX, GetY, FollowsParent, SetFollowsParent
	*/
	int				GetWorldXY(int nIndex, double* px, double* py);
	/// end MARKER_INFO_SNAP_TO_DATA_CLEANUP

	// Comments last updated by Sim on 03/12/07
	/**
	Remarks: Use it to get follow parent mode value
		
	Keywords:  anchor, marker, MarkerInfo
		
	Example1: curve translate.oxf
		
	Parameters:		

	Return:
			TRUE if anchor follows the parent
			FALSE if anchor does not follow the parent
		
	SeeAlso:
		SetXY, GetX, GetY, GetWorldXY, SetFollowsParent
	*/
	BOOL			FollowsParent();
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks: Use this method to set follow parent mode.
		In this mode anchor X coordinate actually holds index of parent point to which it is attached.
		
	Keywords:  anchor, marker, MarkerInfo
		
	Example1: curve translate.oxf
		
	Parameters:
		bSet = true or false

	Return:
		
	SeeAlso:
		SetXY, GetX, GetY, GetWorldXY, FollowsParent
	*/
	void			SetFollowsParent(bool bSet = true);

	/// ML 12/12/2008 QA70-12715 SNAPTO_FOR_ALL_GRAPHOBJINFOS
	/**
	Remarks: 
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool 	SnapTo(GraphObjInfo& gro, int nIndex = 0);
	/// end SNAPTO_FOR_ALL_GRAPHOBJINFOS

};

////////////////////////////////////////////////
// class ButtonInfo
////////////////////////////////////////////////
// Comments last updated by Joseph on 04/04/2007
/**# >
*/
class ButtonInfo : public GraphObjInfo
{
public:
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	ButtonInfo(TreeNode &tr, DWORD dwUIDMain = 0);
	~ButtonInfo();
	
public:	
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void Init(int nBitmapID = OTCIC_COMBOBOX, int nSize = 12);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void Init(LPCSTR lpcszText, int nSize = 12);
};

enum {LN_FREE, LN_HORIZONTAL, LN_VERTICAL};
enum {LNPOS_LEFT, LNPOS_CENTER, LNPOS_RIGHT};// relative to parent

////////////////////////////////////////////////
// class LineInfo
////////////////////////////////////////////////
// Comments last updated by Joseph on 04/04/2007
/**# >
*/
class LineInfo : public GraphObjInfo
{
public:
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	LineInfo(TreeNode &tr, DWORD dwUIDMain = 0);
	~LineInfo();
	
public:	
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void 	MoveTo(double x, double y);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void 	LineTo(double x, double y);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void 	SetVertical(bool bSet = true, bool bSpanLayer = true);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void 	SetHorizontal(bool bSet = true, bool bSpanLayer = true);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:
		dp=[input]dataplot to be snapped to
		nPoint=[input]data point index of dp, 0 offset
	
	Return:
		
	SeeAlso:
	*/
	//------ Folger 11/26/08 QA80-12367-S1 v8.0980 LINEINFO_SNAP_TO_DATA_SUPPORT_DATA_POINT_INDEX_ACCESS
	//bool 	SnapToData(DataPlot& dp = NULL);
	bool 	SnapToData(DataPlot& dp = NULL, int nPoint = -1);
	//------
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	/// ML 12/12/2008 QA70-12715 SNAPTO_FOR_ALL_GRAPHOBJINFOS
	//bool 	SnapTo(GraphObjInfo& gro, int nIndex = 0);
	/// end SNAPTO_FOR_ALL_GRAPHOBJINFOS
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool 	SnapToParentXY(bool b1stPtTo1stDataPt = false, bool bLastPtToLastDataPt = false);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	bool 	SnapToParent(int nIndex);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void 	SetWidth(double dWidth);
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void 	Init(int nType, int nPos, double dWidth = 0.2, DWORD dwColor = 1, bool bFollowParent = false);
};

////////////////////////////////////////////////
// class TextInfo
////////////////////////////////////////////////
// Comments last updated by Joseph on 04/04/2007
/**# >
*/
class TextInfo : public GraphObjInfo
{
public:
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	TextInfo(TreeNode &tr, DWORD dwUIDMain = 0);
	~TextInfo();
	
public:
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	void Init(LPCSTR lpcszText, int nSize = 12);
};


////////////////////////////////////////////////
// class EventInfo
////////////////////////////////////////////////
// Comments last updated by Joseph on 04/04/2007
/**# >
*/
class EventInfo : public InfoBase
{
public:
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	EventInfo(TreeNode &tr, DWORD dwUIDMain = 0);
	~EventInfo();

public:	
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	int		GetEvent();
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	int		GetSenderId();
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	int		GetSenderParam();
};
/// end NEW_GROBJ_BASED_X_VARIABLE_TYPES

/// RVD 11/22/2006 QA70-9148 v8.0515 IMPLEMENT_RECTINFO
////////////////////////////////////////////////
// class RectInfo
////////////////////////////////////////////////
// Comments last updated by Joseph on 04/04/2007
/**# >
*/
class RectInfo : public GraphObjInfo
{
public:
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	RectInfo(TreeNode &tr, DWORD dwUIDMain = 0);
	~RectInfo();
};
/// end IMPLEMENT_RECTINFO

/// RVD 4/15/2005 QA70-7597 v8.0223 MARKER_GROBJ
////////////////////////////////////////////////
// class MarkerInfo
////////////////////////////////////////////////
// Comments last updated by Joseph on 04/04/2007
/**# >
*/
class MarkerInfo : public LineInfo
{
public:
	// Comments last updated by Sim on 03/12/07
	/**
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:		

	Return:
		
	SeeAlso:
	*/
	MarkerInfo(TreeNode &tr, DWORD dwUIDMain = 0);
	~MarkerInfo();
};

void arrange_buttons(ButtonInfo& bi, GraphObjInfo& bn2 = NULL, GraphObjInfo& bn3 = NULL);
bool find_data_inside_tool(GraphObject& grTool, bool bUpdateTool, DataRange& dr, ButtonInfo& biMenu, int nMinPts = 2, GraphObjInfo& ob2 = NULL);
bool get_end_points(const DataRange& dr, double& x1, double& x2, double* py1=NULL, double* py2 = NULL);

/// YuI 06/28/05 TRANSLATION_OF_XVAR_BRANCH
bool construct_active_data_range(DataRange& dr, DWORD dwDataRules);
/// end TRANSLATION_OF_XVAR_BRANCH

/// YuI 03/13/09 QA70-13281 TAGGING_AVECURVES_RESULTS_TO_EXCLUDE_THEM_FROM_FUTURE_AVERAGING
void	tag_columns_in_data_range(DataRange &rg, LPCSTR lpcszTag);
/// end TAGGING_AVECURVES_RESULTS_TO_EXCLUDE_THEM_FROM_FUTURE_AVERAGING

///------ Folger 01/06/09 QA81-14903 FILTER_DATAPLOTS_TAGS_WITH_FITCURVES
BOOL	is_dataobj_tagged(DataObject& obj, LPCSTR lpcszTag);
///------ End FILTER_DATAPLOTS_TAGS_WITH_FITCURVES

string	get_fitter_results_curve_table_tagname(int nGraphIndex);
#define STR_FIT_CURVES_TABLE				"FitCurves" 
#define STR_RESIDUALS_DATA_TABLE			"ResidualData"
#define STR_RESIDUALS_SCATTER_TABLE			"ResidualsScatter"
#define STR_RESIDUALS_HISTOGRAM_TABLE		"ResidualsHistogram"
#define STR_RESIDUALS_FIT_GRAPH_TABLE 		"ResidualsFit"
#define STR_RESIDUALS_ORDER_GRAPH_TABLE 	"ResidualsOrder"
#define STR_RESIDUALS_LAG_GRAPH_TABLE		"ResidualsLag"	///Jim 2/22/06 v8.0368 ADD_RESIDUAL_LAG_PLOT_TO_RESIDUALS_PLOTS_BRANCH
enum
{
	GRAPH_FIT_CURVE = 0,  //Fit curve always is 0
	GRAPH_RESIDUALS_SCATTER, 
	GRAPH_RESIDUALS_HISTOGRAM,
	GRAPH_RESIDUALS_VERSUS_FITS_PLOT,
	GRAPH_RESIDUALS_VERSUS_ORDER_PLOT,	
	GRAPH_RESIDUALS_LAG_PLOT, ///Jim 2/22/06 v8.0368 ADD_RESIDUAL_LAG_PLOT_TO_RESIDUALS_PLOTS_BRANCH
	GRAPH_FITTING_MAX_NODES_IN_REPORT,
};

///---Sim 01-17-2007 QA80-10952 MULTI_SHEET_RANGE
//Comments last updated by Iris 7/29/2008, added $
/**$
*/
class SheetRangesList
{
public:
	// break up the range and order/sort into a list by datasheets
	SheetRangesList(const DataRange &dr);
public:
	// get number of different datasheets
	int GetNumSheets();
	
	// get number of sub ranges in same datasheets
	int GetNumSubRange(int nSheetIndex);
	
	// get range info
	bool GetRange(int nSheetIndex, Datasheet& ds, int nSheetSubRangeIndex = 0, ORANGE* pRange = NULL);
	
	// get corresponding original sub range index
	int GetSubRangeIndex(int nSheetIndex, int nSheetSubRangeIndex);
	
	//------ Folger 02/14/08 QA80-10946 SUPPORT_GET_SUB_RANGE_PER_SHEET
	bool	GetWksSubRange(int nSheetIndex, DataRange &drSub, Datasheet *pds = NULL);
	//-----
	
protected:
	DataRange		m_dr;

private:
	// datasheets UID array, sorted ascending
	vector<uint>	m_vnIDs;
	
	// UID array will be sorted, but sub ranges of m_dr will not.
	// vnIndeces is such index vector for get unsorted sub ranges info.
	vector<uint>	m_vnIndeces;									
	
	int				m_nNumSheets;
	
	// for each datasheet get start offset index of UID array
	vector<int>		m_vnOffsetSheets;
};
///---END QA80-10952 MULTI_SHEET_RANGE

#endif //_RANGE_H

